%% Code to generate Fig5a
% AoD estimation error with different choices of voltage levels

clear all
close all
clc

aspread_aoa = 30; no_sim = 10^6;
case_val = 1;
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load)
figure
semilogy(SNR_dB, (MSE_sd_doa_det), 'k:','LineWidth',1.2)
hold on


aspread_aoa = 30;
case_val = 0;
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load)
semilogy(SNR_dB, (MSE_sd_aoa_det), 'b-','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_a_aoa_det), 'r--','LineWidth',1.2)


legend('SD, arbitrary c','SD, proposed c','UQ');
xlabel('SNR (dB)')
ylabel('AoA estimation error (E_{\theta})')
grid on
ylim([10^(-4) 1.1])
xlim([-15 15])

savefig('Fig5b.fig')
saveas(gcf,'Fig5b','epsc')